#ifndef __C_PBCASTNODE_H
#define __C_PBCASTNODE_H

#define WIN32_LEAN_AND_MEAN

#define MAX_HEARTBEAT 65535
#define MAX_SEQNUM	  4294967295

#include "Interfaces/cObject.h"
#include <ostream.h>
#include <winsock2.h>

class cEndpoint;

/*
 * cPbcastNode.h
 *
 * Holds the node information for a pbcast node.
 */
class cPbcastNode : public cHashObject
{
  public:

	cPbcastNode(cEndpoint *ep);
	cPbcastNode();
	~cPbcastNode();

	void	AddRef()  {  }
	void	Release() {  }

	bool			LessThan(cHashObject* hObj);
	bool			Equals(cHashObject* hObj);
	unsigned int	GetSize();
	unsigned int	HashCode();
	void Print(ostream &errStream);	
	char* Serialize(char* buffer, int *size);
	char* Deserialize(char* buffer, int *size);
	static char* MinSerialize(cPbcastNode* node, char* buffer, int* size);
	static char* MinDeserialize(cPbcastNode* node, char* buffer, int* size);
	static bool	 SeqNumOlder(u_long a, u_long b);	// true if a is older than b
	static unsigned int SeqNumDifference(u_long older, u_long newer);
	static int	 GetMinSerialSize();

	bool		 HeartbeatOlder(cPbcastNode* newNode);

	bool		 mSeenFirstMsg;

	cEndpoint*		 mEndpoint;
	u_short			 mHeartbeat;
	u_long			 mGossipSeqNum;
	u_long			 mLastDeliveredSeqNum;
	DWORD			 mLastUpdateTime;
};

#endif